## HddUtil.exe
Это программа для Windows2000, Windows2003, WindowsXP, Vista,
позволяющая работать с посекторными копиями жестких дисков - считывать
копию диска в файл (формат OHI) и записывать из файла обратно на диск.
Программа очень удобна для переноса данных с реальных HDD в
образы дисков и обратно "один в один", имеет текстовый (консольный)
интерфейс - режим её работы зависит от параметров командной строки,
переданных при запуске.

## Общий форма вызова программы:
  `HddUtil [<источник - диск или файл> <приемник>] [параметры]`

## Параметры командной строки:
```
Details: HddUtil <drive> <image> [/s=<nn>] [/c=<nn>] [/q]
         HddUtil <image> <drive> [/s=<nn>] [/c=<nn>] [/q]
         HddUtil /list [<drive>]

 где 
 <drive>:  спецификатор диска / партиции, обычно "0:".."9:" / "C:".."Z:"
 <image>:  полное имя файла (путь+имя) OHI-образа диска или имя
           файла в текущем каталоге
    <nn>:  десятичное число
     /s=:  номер 512-байтного сектора (LBA N), начиная с которого писАть
     /c=:  сколько 512-байтных секторов зависать (т.е. размер фрагмента)
      /q:  quet mode (в процессе не вывподить счетчик обработанных секторов)
   /list:  показать краткую информацию о доступных жестких дисках
```

В зависимости от порядка следования параметров <drive> и <image>, а
также наличия параметров возможны следующие режимы работы программы:

1. Показать краткую информацию о доступных жестких дисках:
      `HddUtil /list`
2. Записать образ диска 0: в файл d:\drive0.ohi
      `HddUtil 0: d:\drive0.ohi`
3. Записать boot-sector партиции С: в файл d:\driveС-0.dat
      `HddUtil C: d:\driveC-0.dat /c=1`
4. Записать файл-образ c:\drive1.ohi на диск 1:
      `HddUtil  c:\drive1.ohi  1:`

Если программа ругается, что размер образа не соответствует размеру диска 
(защита от дурака), и пишет, что "если образ не соответствует, надо
указывать сколько секторов писать - (/c=12345678)", то столько и указываем:
      `hddutil.exe c:\drive1.ohi 1: /c=12345678`

Далее со скопированными образами HDD простой посекторной копии
(формат OHI) можно работать как с архивами (файловой системой) при
помощи плагинов OhiWcx для Total Commander и Far Manager.

Эти плагины поддерживают все файловые функции внутри архива - работать
можно как с обычными подкаталогами с файлами.

```
//                                                                     //
//   Author: Sergey A.        <a-s-m@km.ru>                            //
//                                                                     //
//   Copyright (C)2016 Sergey A.                                       //
//                                                                     //
```